/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api;

import java.io.File;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.EventBus;
import noppes.npcs.LogWriter;
import noppes.npcs.api.CommandNoppesBase;
import noppes.npcs.api.IContainer;
import noppes.npcs.api.IDamageSource;
import noppes.npcs.api.IEntityDamageSource;
import noppes.npcs.api.IMethods;
import noppes.npcs.api.INbt;
import noppes.npcs.api.IPos;
import noppes.npcs.api.IWorld;
import noppes.npcs.api.block.IBlock;
import noppes.npcs.api.entity.ICustomNpc;
import noppes.npcs.api.entity.IEntity;
import noppes.npcs.api.entity.IPlayer;
import noppes.npcs.api.entity.data.IData;
import noppes.npcs.api.entity.data.INpcAttribute;
import noppes.npcs.api.entity.data.IPlayerMail;
import noppes.npcs.api.gui.ICustomGui;
import noppes.npcs.api.handler.IAnimationHandler;
import noppes.npcs.api.handler.IBorderHandler;
import noppes.npcs.api.handler.ICloneHandler;
import noppes.npcs.api.handler.ICustomPlayerData;
import noppes.npcs.api.handler.IDialogHandler;
import noppes.npcs.api.handler.IDimensionHandler;
import noppes.npcs.api.handler.IFactionHandler;
import noppes.npcs.api.handler.IKeyBinding;
import noppes.npcs.api.handler.IMarcetHandler;
import noppes.npcs.api.handler.IQuestHandler;
import noppes.npcs.api.handler.IRecipeHandler;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.api.wrapper.WrapperNpcAPI;
import noppes.npcs.client.gui.util.IResourceData;

public abstract class NpcAPI {
    private static NpcAPI instance = null;

    public static NpcAPI Instance() {
        if (instance != null) {
            return instance;
        }
        if (!NpcAPI.IsAvailable()) {
            return null;
        }
        try {
            instance = WrapperNpcAPI.Instance();
        }
        catch (Exception e) {
            LogWriter.error(e);
        }
        return instance;
    }

    public static boolean IsAvailable() {
        return Loader.isModLoaded((String)"customnpcs");
    }

    public abstract ICustomGui createCustomGui(int var1, int var2, int var3, boolean var4);

    public abstract IPlayerMail createMail(String var1, String var2);

    public abstract ICustomNpc<?> createNPC(World var1);

    public abstract EventBus events();

    public abstract String executeCommand(IWorld var1, String var2);

    public abstract IPlayer<?>[] getAllPlayers();

    public abstract IAnimationHandler getAnimations();

    public abstract IBorderHandler getBorders();

    public abstract ICloneHandler getClones();

    public abstract IDimensionHandler getCustomDimension();

    public abstract IDialogHandler getDialogs();

    public abstract IFactionHandler getFactions();

    public abstract File getGlobalDir();

    public abstract INpcAttribute getIAttribute(IAttributeInstance var1);

    public abstract IBlock getIBlock(World var1, BlockPos var2);

    public abstract IContainer getIContainer(Container var1);

    public abstract IContainer getIContainer(IInventory var1);

    public abstract IDamageSource getIDamageSource(DamageSource var1);

    public abstract IEntityDamageSource getIDamageSource(String var1, IEntity<?> var2);

    public abstract IEntity<?> getIEntity(Entity var1);

    public abstract IItemStack getIItemStack(ItemStack var1);

    public abstract IKeyBinding getIKeyBinding();

    public abstract INbt getINbt(NBTTagCompound var1);

    public abstract IPlayer<?> getIPlayer(String var1);

    public abstract IPos getIPos(BlockPos var1);

    public abstract IPos getIPos(double var1, double var3, double var5);

    public abstract IWorld getIWorld(String var1);

    public abstract IWorld getIWorld(int var1);

    public abstract IWorld getIWorld(World var1);

    public abstract IWorld[] getIWorlds();

    public abstract IMarcetHandler getMarkets();

    public abstract IMethods getMethods();

    public abstract IQuestHandler getQuests();

    public abstract String getRandomName(int var1, int var2);

    public abstract INbt getRawPlayerData(String var1, String var2);

    public abstract IRecipeHandler getRecipes();

    public abstract File getWorldDir();

    public abstract boolean hasPermissionNode(String var1);

    public abstract void registerCommand(CommandNoppesBase var1);

    public abstract void registerPermissionNode(String var1, int var2);

    public abstract ICustomNpc<?> spawnNPC(World var1, int var2, int var3, int var4);

    public abstract INbt stringToNbt(String var1);

    public abstract ICustomPlayerData getPlayerData(EntityPlayer var1);

    public abstract IResourceData getResourceData(ResourceLocation var1, int var2, int var3, int var4, int var5);

    public abstract IData getTempdata();

    public abstract IData getStoreddata();
}

